package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import java.util.ArrayList;
import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to update a list of Persons in the DB.
 * Created by david on 07.03.16.
 */
public class UpdatePersonsInDb extends AsyncTask<Void, Integer, Void> {

    private Context context;
    private PersonDao personDao;
    private IUpdatePersonsInDb iUpdatePersonsInDb;
    private List<Person> mPersons;
    private List<Person> mUpdatedPersons;

    public UpdatePersonsInDb(Context context, IUpdatePersonsInDb iUpdatePersonsInDb, List<Person> persons) {
        this.context = context;
        this.iUpdatePersonsInDb = iUpdatePersonsInDb;
        mPersons = persons;
        mUpdatedPersons = new ArrayList<>();
    }


    @Override
    protected Void doInBackground(Void... params) {
        personDao = new PersonDao(context);
        personDao.openWritable();
        for (Person p : mPersons) {
            mUpdatedPersons.add(personDao.update(p));
        }
        return null;
    }

    @Override
    protected void onPostExecute(Void aVoid) {
        super.onPostExecute(aVoid);
        iUpdatePersonsInDb.onUpdate(mUpdatedPersons);
        personDao.close();
    }

    public interface IUpdatePersonsInDb {
        void onUpdate(List<Person> updatedPersons);
    }
}
